package ONVIF::Device::Types::EngineConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %VideoAnalyticsConfiguration_of :ATTR(:get<VideoAnalyticsConfiguration>);
my %AnalyticsEngineInputInfo_of :ATTR(:get<AnalyticsEngineInputInfo>);

__PACKAGE__->_factory(
    [ qw(        VideoAnalyticsConfiguration
        AnalyticsEngineInputInfo

    ) ],
    {
        'VideoAnalyticsConfiguration' => \%VideoAnalyticsConfiguration_of,
        'AnalyticsEngineInputInfo' => \%AnalyticsEngineInputInfo_of,
    },
    {
        'VideoAnalyticsConfiguration' => 'ONVIF::Device::Types::VideoAnalyticsConfiguration',
        'AnalyticsEngineInputInfo' => 'ONVIF::Device::Types::AnalyticsEngineInputInfo',
    },
    {

        'VideoAnalyticsConfiguration' => 'VideoAnalyticsConfiguration',
        'AnalyticsEngineInputInfo' => 'AnalyticsEngineInputInfo',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::EngineConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
EngineConfiguration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * VideoAnalyticsConfiguration


=item * AnalyticsEngineInputInfo




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::EngineConfiguration
   VideoAnalyticsConfiguration =>  { # ONVIF::Device::Types::VideoAnalyticsConfiguration
     AnalyticsEngineConfiguration =>  { # ONVIF::Device::Types::AnalyticsEngineConfiguration
       AnalyticsModule =>  { # ONVIF::Device::Types::Config
         Parameters =>  { # ONVIF::Device::Types::ItemList
           SimpleItem => ,
           ElementItem =>  {
           },
           Extension =>  { # ONVIF::Device::Types::ItemListExtension
           },
         },
       },
       Extension =>  { # ONVIF::Device::Types::AnalyticsEngineConfigurationExtension
       },
     },
     RuleEngineConfiguration =>  { # ONVIF::Device::Types::RuleEngineConfiguration
       Rule =>  { # ONVIF::Device::Types::Config
         Parameters =>  { # ONVIF::Device::Types::ItemList
           SimpleItem => ,
           ElementItem =>  {
           },
           Extension =>  { # ONVIF::Device::Types::ItemListExtension
           },
         },
       },
       Extension =>  { # ONVIF::Device::Types::RuleEngineConfigurationExtension
       },
     },
   },
   AnalyticsEngineInputInfo =>  { # ONVIF::Device::Types::AnalyticsEngineInputInfo
     InputInfo =>  { # ONVIF::Device::Types::Config
       Parameters =>  { # ONVIF::Device::Types::ItemList
         SimpleItem => ,
         ElementItem =>  {
         },
         Extension =>  { # ONVIF::Device::Types::ItemListExtension
         },
       },
     },
     Extension =>  { # ONVIF::Device::Types::AnalyticsEngineInputInfoExtension
     },
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

