package ONVIF::Media::Types::RecordingCapabilities;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %XAddr_of :ATTR(:get<XAddr>);
my %ReceiverSource_of :ATTR(:get<ReceiverSource>);
my %MediaProfileSource_of :ATTR(:get<MediaProfileSource>);
my %DynamicRecordings_of :ATTR(:get<DynamicRecordings>);
my %DynamicTracks_of :ATTR(:get<DynamicTracks>);
my %MaxStringLength_of :ATTR(:get<MaxStringLength>);

__PACKAGE__->_factory(
    [ qw(        XAddr
        ReceiverSource
        MediaProfileSource
        DynamicRecordings
        DynamicTracks
        MaxStringLength

    ) ],
    {
        'XAddr' => \%XAddr_of,
        'ReceiverSource' => \%ReceiverSource_of,
        'MediaProfileSource' => \%MediaProfileSource_of,
        'DynamicRecordings' => \%DynamicRecordings_of,
        'DynamicTracks' => \%DynamicTracks_of,
        'MaxStringLength' => \%MaxStringLength_of,
    },
    {
        'XAddr' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
        'ReceiverSource' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'MediaProfileSource' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'DynamicRecordings' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'DynamicTracks' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'MaxStringLength' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'XAddr' => 'XAddr',
        'ReceiverSource' => 'ReceiverSource',
        'MediaProfileSource' => 'MediaProfileSource',
        'DynamicRecordings' => 'DynamicRecordings',
        'DynamicTracks' => 'DynamicTracks',
        'MaxStringLength' => 'MaxStringLength',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::RecordingCapabilities

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RecordingCapabilities from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * XAddr


=item * ReceiverSource


=item * MediaProfileSource


=item * DynamicRecordings


=item * DynamicTracks


=item * MaxStringLength




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::RecordingCapabilities
   XAddr =>  $some_value, # anyURI
   ReceiverSource =>  $some_value, # boolean
   MediaProfileSource =>  $some_value, # boolean
   DynamicRecordings =>  $some_value, # boolean
   DynamicTracks =>  $some_value, # boolean
   MaxStringLength =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

