package ONVIF::Media::Types::VideoRateControl;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %FrameRateLimit_of :ATTR(:get<FrameRateLimit>);
my %EncodingInterval_of :ATTR(:get<EncodingInterval>);
my %BitrateLimit_of :ATTR(:get<BitrateLimit>);

__PACKAGE__->_factory(
    [ qw(        FrameRateLimit
        EncodingInterval
        BitrateLimit

    ) ],
    {
        'FrameRateLimit' => \%FrameRateLimit_of,
        'EncodingInterval' => \%EncodingInterval_of,
        'BitrateLimit' => \%BitrateLimit_of,
    },
    {
        'FrameRateLimit' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'EncodingInterval' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'BitrateLimit' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'FrameRateLimit' => 'FrameRateLimit',
        'EncodingInterval' => 'EncodingInterval',
        'BitrateLimit' => 'BitrateLimit',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::VideoRateControl

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
VideoRateControl from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * FrameRateLimit


=item * EncodingInterval


=item * BitrateLimit




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::VideoRateControl
   FrameRateLimit =>  $some_value, # int
   EncodingInterval =>  $some_value, # int
   BitrateLimit =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

