package ONVIF::PTZ::Types::PTZPresetTourStartingCondition;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %RecurringTime_of :ATTR(:get<RecurringTime>);
my %RecurringDuration_of :ATTR(:get<RecurringDuration>);
my %Direction_of :ATTR(:get<Direction>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        RecurringTime
        RecurringDuration
        Direction
        Extension

    ) ],
    {
        'RecurringTime' => \%RecurringTime_of,
        'RecurringDuration' => \%RecurringDuration_of,
        'Direction' => \%Direction_of,
        'Extension' => \%Extension_of,
    },
    {
        'RecurringTime' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'RecurringDuration' => 'SOAP::WSDL::XSD::Typelib::Builtin::duration',
        'Direction' => 'ONVIF::PTZ::Types::PTZPresetTourDirection',
        'Extension' => 'ONVIF::PTZ::Types::PTZPresetTourStartingConditionExtension',
    },
    {

        'RecurringTime' => 'RecurringTime',
        'RecurringDuration' => 'RecurringDuration',
        'Direction' => 'Direction',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::PTZPresetTourStartingCondition

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
PTZPresetTourStartingCondition from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * RecurringTime


=item * RecurringDuration


=item * Direction


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::PTZPresetTourStartingCondition
   RecurringTime =>  $some_value, # int
   RecurringDuration =>  $some_value, # duration
   Direction => $some_value, # PTZPresetTourDirection
   Extension =>  { # ONVIF::PTZ::Types::PTZPresetTourStartingConditionExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

