package ONVIF::PTZ::Types::VideoAnalyticsConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(ONVIF::PTZ::Types::ConfigurationEntity);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Name_of :ATTR(:get<Name>);
my %UseCount_of :ATTR(:get<UseCount>);
my %AnalyticsEngineConfiguration_of :ATTR(:get<AnalyticsEngineConfiguration>);
my %RuleEngineConfiguration_of :ATTR(:get<RuleEngineConfiguration>);

__PACKAGE__->_factory(
    [ qw(        Name
        UseCount
        AnalyticsEngineConfiguration
        RuleEngineConfiguration

    ) ],
    {
        'Name' => \%Name_of,
        'UseCount' => \%UseCount_of,
        'AnalyticsEngineConfiguration' => \%AnalyticsEngineConfiguration_of,
        'RuleEngineConfiguration' => \%RuleEngineConfiguration_of,
    },
    {
        'Name' => 'ONVIF::PTZ::Types::Name',
        'UseCount' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'AnalyticsEngineConfiguration' => 'ONVIF::PTZ::Types::AnalyticsEngineConfiguration',
        'RuleEngineConfiguration' => 'ONVIF::PTZ::Types::RuleEngineConfiguration',
    },
    {

        'Name' => 'Name',
        'UseCount' => 'UseCount',
        'AnalyticsEngineConfiguration' => 'AnalyticsEngineConfiguration',
        'RuleEngineConfiguration' => 'RuleEngineConfiguration',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::VideoAnalyticsConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
VideoAnalyticsConfiguration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * AnalyticsEngineConfiguration


=item * RuleEngineConfiguration




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::VideoAnalyticsConfiguration
   AnalyticsEngineConfiguration =>  { # ONVIF::PTZ::Types::AnalyticsEngineConfiguration
     AnalyticsModule =>  { # ONVIF::PTZ::Types::Config
       Parameters =>  { # ONVIF::PTZ::Types::ItemList
         SimpleItem => ,
         ElementItem =>  {
         },
         Extension =>  { # ONVIF::PTZ::Types::ItemListExtension
         },
       },
     },
     Extension =>  { # ONVIF::PTZ::Types::AnalyticsEngineConfigurationExtension
     },
   },
   RuleEngineConfiguration =>  { # ONVIF::PTZ::Types::RuleEngineConfiguration
     Rule =>  { # ONVIF::PTZ::Types::Config
       Parameters =>  { # ONVIF::PTZ::Types::ItemList
         SimpleItem => ,
         ElementItem =>  {
         },
         Extension =>  { # ONVIF::PTZ::Types::ItemListExtension
         },
       },
     },
     Extension =>  { # ONVIF::PTZ::Types::RuleEngineConfigurationExtension
     },
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

