/*
Copyright 2011-2017  Francesco Cecconi <francesco.cecconi@gmail.com>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef VULNERABILITY_H
#define VULNERABILITY_H

#include "ui_vulnerabilitywidget.h"

#include <QtCore/QObject>
#include <QtCore/QHash>
#include <QtCore/QList>
#include <QtCore/QPair>
#include <QCompleter>
#include <QStringListModel>
#include <QSplitter>
#include <QWebEngineView>
#include <QWebEnginePage>
#include <QtQuick/QQuickView>
#include <QPointer>

// local include
#include "addvulnerabilityurl.h"
#include "package.h"

class MainWindow;

class VulnerabilityWidget : public QWidget, public Ui::VulnerabilityWidgetForm
{
    Q_OBJECT
public:
    explicit VulnerabilityWidget(QWidget* parent = 0);
};

class Vulnerability : public QObject
{
    Q_OBJECT

public:
    explicit Vulnerability(MainWindow* parent);
    ~Vulnerability();
    /**
    * Load search url into dedicate combo.
    **/
    void loadSearchUrlIntoCombo();
    void syncSettings();

    VulnerabilityWidget* m_vulnerabilityWidget;
    QSplitter* m_mainHorizontalLeftSplitter;


private:
    void updateCompleter();
    const QList< QPair<QString, QString> > getDefaultUrlList();

    QList<QWebEngineView*> m_webViewList;
    MainWindow* m_ui;
    QQuickView* m_welcomeQml;
    QCompleter* m_completerVuln;
    QStringListModel* m_vulnModel;

public slots:
    /**
     * Search Vulnerability with comboVulnRis string
     **/
    void openTab(const QUrl& address, const QString& tabName);
    void searchVulnerabilityFromCombo();
    void tabWebBack();
    void tabWebForward();
    void tabWebStop();
    void callVulnCheck();
    void checkVulnerabilitiesFromPortsTree();
    void showAddUrlUi();
    void openUrlFromScanPortsTree();
    void removeUrlToBookmarks();

private slots:
    void vulnPostScan();
    void addUrlToBookmarks(const QString urlName, const QString urlAddr);
    void linkCompleterToServices();
    void closeVulnTab(int index);
    void updateComboServicesProperties();
    void updateComboVuln(int index);
    void searchVulnFromTreeWidget();
};

#endif // VULNERABILITY_H
