% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locale.R
\name{locale}
\alias{locale}
\alias{default_locale}
\title{Create locales}
\usage{
locale(
  date_names = "en",
  date_format = "\%AD",
  time_format = "\%AT",
  decimal_mark = ".",
  grouping_mark = ",",
  tz = "UTC",
  encoding = "UTF-8",
  asciify = FALSE
)

default_locale()
}
\arguments{
\item{date_names}{Character representations of day and month names. Either
the language code as string (passed on to \code{\link[=date_names_lang]{date_names_lang()}})
or an object created by \code{\link[=date_names]{date_names()}}.}

\item{date_format, time_format}{Default date and time formats.}

\item{decimal_mark, grouping_mark}{Symbols used to indicate the decimal
place, and to chunk larger numbers. Decimal mark can only be \verb{,} or
\code{.}.}

\item{tz}{Default tz. This is used both for input (if the time zone isn't
present in individual strings), and for output (to control the default
display). The default is to use "UTC", a time zone that does not use
daylight savings time (DST) and hence is typically most useful for data.
The absence of time zones makes it approximately 50x faster to generate
UTC times than any other time zone.

Use \code{""} to use the system default time zone, but beware that this
will not be reproducible across systems.

For a complete list of possible time zones, see \code{\link[=OlsonNames]{OlsonNames()}}.
Americans, note that "EST" is a Canadian time zone that does not have
DST. It is \emph{not} Eastern Standard Time. It's better to use
"US/Eastern", "US/Central" etc.}

\item{encoding}{Default encoding. This only affects how the file is
read - readr always converts the output to UTF-8.}

\item{asciify}{Should diacritics be stripped from date names and converted to
ASCII? This is useful if you're dealing with ASCII data where the correct
spellings have been lost. Requires the \pkg{stringi} package.}
}
\description{
A locale object tries to capture all the defaults that can vary between
countries. You set the locale in once, and the details are automatically
passed on down to the columns parsers. The defaults have been chosen to
match R (i.e. US English) as closely as possible. See
\code{vignette("locales")} for more details.
}
\examples{
locale()
locale("fr")

# A South American locale
locale("es", decimal_mark = ",")
}
